/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventBroadcastHelper
implements EventBroadcaster {
    Collection[] c = new Collection[EventType.EVENT_TYPE_NUM];
    boolean[] busy = new boolean[EventType.EVENT_TYPE_NUM];
    int[] start = null;
    int cnt = 0;
    Boolean orderMaintained = true;
    Object orderMaintainedLock = new Object();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock shareLock = this.lock.readLock();
    private Lock exclusiveLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderMaintained(boolean order) {
        Object object = this.orderMaintainedLock;
        synchronized (object) {
            this.orderMaintained = order;
            if (!this.orderMaintained.booleanValue()) {
                this.start = new int[EventType.EVENT_TYPE_NUM];
            }
        }
    }

    public void clear() {
        this.exclusiveLock.lock();
        try {
            this.c = new Collection[EventType.EVENT_TYPE_NUM];
            for (int i = 0; i < EventType.EVENT_TYPE_NUM; ++i) {
                this.busy[i] = false;
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    public void dump(PrintStream ps) {
        ps.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("EventBroadcastHelper {\n");
        this.shareLock.lock();
        try {
            str.append("\tcnt=" + this.cnt + "\n");
            int len = this.c.length;
            for (int i = 0; i < len; ++i) {
                boolean indent = false;
                str.append("\t" + i + "busy[" + i + "]=" + this.busy[i] + " { ");
                if (this.c[i] == null) {
                    str.append("null");
                } else {
                    Iterator itr = this.c[i].iterator();
                    boolean first = true;
                    int indx = 0;
                    while (itr.hasNext()) {
                        ListenerInfo li = (ListenerInfo)itr.next();
                        indent = true;
                        if (!first) {
                            str.append("\t    ");
                        }
                        first = false;
                        str.append(indx + ":  " + li.getListener() + "\n\t        " + li.getType() + "\n\t        " + li.getReason() + "\n\t        " + li.getUserData() + "\n");
                        ++indx;
                    }
                }
                if (indent) {
                    str.append("\t  }\n");
                    continue;
                }
                str.append(" }\n");
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return str.toString();
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object userData) {
        return this.addEventListener(listener, type, null, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) {
        ListenerInfo li = new ListenerInfo(listener, type, reason, userData);
        int indx = type.getEvent();
        this.exclusiveLock.lock();
        try {
            if (this.c[indx] == null) {
                this.c[indx] = new ArrayList();
                this.c[indx].add(li);
            } else {
                ArrayList<ListenerInfo> ls = new ArrayList<ListenerInfo>(this.c[indx]);
                ls.add(li);
                this.c[indx] = ls;
            }
            this.busy[indx] = true;
            ++this.cnt;
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeEventListener(Object id) {
        this.exclusiveLock.lock();
        try {
            if (id == null) {
                Object var2_2 = null;
                return var2_2;
            }
            ListenerInfo li = (ListenerInfo)id;
            if (!li.isValid()) {
                Object var3_4 = null;
                return var3_4;
            }
            int indx = li.getType().getEvent();
            Collection s = this.c[indx];
            if (s == null) {
                Object var5_7 = null;
                return var5_7;
            }
            ArrayList newset = new ArrayList(s);
            newset.remove(li);
            this.busy[indx] = !newset.isEmpty();
            this.c[indx] = newset;
            EventListener l = li.getListener();
            li.clear();
            --this.cnt;
            EventListener eventListener = l;
            return eventListener;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(EventType type, Reason r, Object target, Object oldval, Object newval) {
        this.shareLock.lock();
        try {
            ArrayList l = (ArrayList)this.c[type.getEvent()];
            if (l == null || l.isEmpty()) {
                return;
            }
            int offset = 0;
            int size = l.size();
            if (size > 1) {
                Object object = this.orderMaintainedLock;
                synchronized (object) {
                    if (!this.orderMaintained.booleanValue() && this.start != null) {
                        offset = this.start[type.getEvent()];
                        this.start[type.getEvent()] = offset >= size - 1 ? 0 : offset + 1;
                    }
                }
            }
            for (int count = 0; count < size; ++count) {
                int index;
                ListenerInfo info = null;
                int n = index = offset == 0 ? count : (count + offset) % size;
                if (index >= l.size() || (info = (ListenerInfo)l.get(index)) == null) continue;
                EventListener ll = info.getListener();
                Reason lr = info.getReason();
                Object ud = info.getUserData();
                if (ll == null || lr != null && lr != r) continue;
                ll.eventOccured(type, r, target, oldval, newval, ud);
            }
        }
        finally {
            this.shareLock.unlock();
        }
    }

    public boolean hasListeners(EventType type) {
        this.shareLock.lock();
        try {
            boolean bl = this.busy[type.getEvent()];
            return bl;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    public boolean hasListeners() {
        this.shareLock.lock();
        try {
            boolean bl = this.cnt > 0;
            return bl;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    static class ListenerInfo {
        boolean valid = true;
        EventListener l;
        EventType type;
        Object userData;
        Reason reason;

        public ListenerInfo(EventListener l, EventType t, Reason r, Object ud) {
            this.l = l;
            this.type = t;
            this.userData = ud;
            this.reason = r;
        }

        Reason getReason() {
            return this.reason;
        }

        boolean isValid() {
            return this.valid;
        }

        Object getUserData() {
            return this.userData;
        }

        EventType getType() {
            return this.type;
        }

        EventListener getListener() {
            return this.l;
        }

        void clear() {
            this.valid = false;
            this.l = null;
            this.userData = null;
            this.reason = null;
            this.type = null;
        }

        public String toString() {
            return this.l + "[" + this.type + ", reason=" + this.reason + ", userData=" + this.userData + ", valid=" + this.valid + "]";
        }
    }
}

